/*
 * Copyright (C) 2011 HBM Netherlands B.V.
 * Schutweg 15a
 * 5145NP Waalwijk
 * The Netherlands
 * http://www.hbm.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * HBM Acquisition Board driver test program.
 * 
 * Opens HBM acquisition board device, maps memory and uses shared memory
 */

#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/select.h>
#include <sys/mman.h>
#include <linux/types.h>
#include "hbm-acqboard-driver.h"

#define MODNAME				"hbm-acqboard"
#define DEVICE_NAME			"/dev/hbm-acqboard0"
#define MESSAGE_BUFFER_SIZE		128	// bytes
#define FREE_MESSAGE_POINTER_OFFSET	0x40	// offset

void main()
{
	int fd = 0;
	int rv = 0;

	unsigned int * pAcquisitionBoard = NULL;
	unsigned int * pFreeMessagePointer = NULL;
	unsigned int * pMessageBuffer;

	printf("Opening device\n");

	// Open acquisition board
	fd = open(DEVICE_NAME, O_RDWR);

	printf("Mapping device\n");
	
	// Map memory
	rv = mmap();

	// Read free message pointer
	pFreeMessagePointer = pAcquisitionBoard + FREE_MESSAGE_POINTER_OFFSET;

	// Write to message buffer
	printf("Writing to message buffer...\n");

	pMessageBuffer = pFreeMessagePointer;

	for (int i = 0; i < (MESSAGE_BUFFER_SIZE + 1) ; i+=4)
	{
		*pMessageBuffer = (unsigned int)i;
		pMessageBuffer++;
	}

	// Read from message buffer
        pMessageBuffer = pFreeMessagePointer;

	printf("Message Buffer contents: \n");
        for (int i = 0; i < (MESSAGE_BUFFER_SIZE + 1) ; i+=4)
        {
                printf("0x%x ", *pMessageBuffer);
                pMessageBuffer++;
        }
	printf("\n");

	printf("Closing device\n");
	// Close acquisition board
	close(fd);
}
