#ifndef __HBM_BOOTMODE_DRIVER_H__
#define __HBM_BOOTMODE_DRIVER_H__

/*
 * Copyright (C) 2011 HBM Netherlands B.V.
 * Schutweg 15a
 * 5145NP Waalwijk
 * The Netherlands
 * http://www.hbm.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <linux/ioctl.h>

#define HBM_BOOTMODE_DEVICE_NAME    "hbm-bootmode"
#define	HBM_BOOTMODE_DEVICE_PATH	"/dev/hbm-bootmode"

struct gpioData
{
	unsigned int gpioNumber;	// 10 - 35
	unsigned int value;		// only lowest bit is used
	unsigned int gpioPort;		// 1-3
	unsigned int portValue;		// only lowest byte is used
};

#define HBM_BOOTMODE_MAGIC				'r'
#define HBM_BOOTMODE_IOCTL_READ_GPIO		_IOWR(HBM_BOOTMODE_MAGIC, 1, struct gpioData *)
#define HBM_BOOTMODE_IOCTL_WRITE_GPIO		_IOWR(HBM_BOOTMODE_MAGIC, 2, struct gpioData *)
#define HBM_BOOTMODE_IOCTL_TOGGLE_GPIO		_IOWR(HBM_BOOTMODE_MAGIC, 3, struct gpioData *)

#define HBM_BOOTMODE_IOCTL_SELECT_PORT		_IOWR(HBM_BOOTMODE_MAGIC, 4, struct gpioData *)
#define HBM_BOOTMODE_IOCTL_READ_PORT		_IOWR(HBM_BOOTMODE_MAGIC, 5, struct gpioData *)
#define HBM_BOOTMODE_IOCTL_WRITE_PORT		_IOWR(HBM_BOOTMODE_MAGIC, 6, struct gpioData *)
#define HBM_BOOTMODE_IOCTL_DESELECT_PORT	_IOWR(HBM_BOOTMODE_MAGIC, 7, struct gpioData *)

#endif /* __HBM_BOOTMODE_DRIVER_H__ */
