/*
 * Copyright (C) 2011 HBM Netherlands B.V.
 * Schutweg 15a
 * 5145NP Waalwijk
 * The Netherlands
 * http://www.hbm.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <linux/i2c.h>
#include <linux/rtc.h>
#include <linux/module.h>

/*
 * This board info structure driver is needed to register the IM2 specific
 * I2C devices to the I2C stack. Without this registration, the rtc (ds1307)
 * driver will not work.
 */

#define DRV_VERSION "0.2"

static struct i2c_client *i2c_client = NULL;

static struct i2c_board_info i2c_info =
    {
        I2C_BOARD_INFO("ds3231", 0x68)      // RTC chip
    };

static int __init im2_boardinfo_i2c_init(void)
{
    struct i2c_adapter *adap;
    int i;

    // Scan all adapters to find the correct one
    for (i = 0; i < 2; i++)
    {
        adap = i2c_get_adapter(i);

        // Find the "fpga i2c" bus, by name.
        if ( (NULL != adap) &&
             (strcmp(adap->name, "hbm-fpga-i2c-bus") == 0) )
        {
            printk("Found: %s\n", adap->name);
            i2c_client = i2c_new_device(adap, &i2c_info);
            printk("Added: i2c ds3231 support\n");
        }
    }

    return 0;
}

static void __exit im2_boardinfo_i2c_exit(void)
{
    if (NULL != i2c_client)
    {
        i2c_unregister_device(i2c_client);
    }
}

MODULE_AUTHOR("Nathan Huizinga <nathan.huizinga <!at!> chess.nl>");
MODULE_DESCRIPTION("Register IM2 i2c-client(s)");
MODULE_LICENSE("GPL");
MODULE_VERSION(DRV_VERSION);

module_init(im2_boardinfo_i2c_init);
module_exit(im2_boardinfo_i2c_exit);
