#ifndef __HBM_FPGA_CORE_H__
#define __HBM_FPGA_CORE_H__

/*
 * Copyright (C) 2011 HBM Netherlands B.V.
 * Schutweg 15a
 * 5145NP Waalwijk
 * The Netherlands
 * http://www.hbm.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <linux/interrupt.h>
#include <linux/ioctl.h>
#include "hbm-fpga.h"
#include "hbm-fpga-driver.h"

/* Define this to enable ZBuffering on Cpu Shared memory */
/* IMPORTANT: Also update hbm-fpga-api.h when enabling/disabling this constant !!! */
/* #define ZBUF_CPUSHARED */


/* The character driver interface will register the following minor's */
enum {
    FPGA_CHARDEV_MINOR_MSG_QUEUE    = 0,
    FPGA_CHARDEV_MINOR_TIMEBASE,
    FPGA_CHARDEV_MINOR_CMD_NOW,
    FPGA_CHARDEV_MINOR_COMPOUND_PAGE,
    FPGA_CHARDEV_MINOR_MASTERSLAVE,
    FPGA_CHARDEV_MINOR_SIZE,
};

struct hbm_chardev {
    /* Wait queue to sleep on when there is no data available */
    wait_queue_head_t       wait_queue;
    int                     is_active;

    // Data storage
    struct kfifo                fifo ;
    struct kfifo *              fifo_in;

    struct tasklet_struct   tasklet;
    spinlock_t              spinlock_fifo;
    spinlock_t              spinlock_read;
    spinlock_t              spinlock_write;
};


struct hbm_fpga_dev {
    struct pci_dev *        pci_dev;
    struct pci_device_id *  pci_dev_id;

    u8                  irq; /* interrupt number */
    unsigned long               fpga_mem_base_phys;
    void *                  fpga_mem_base_virt;
    size_t                  fpga_mem_size;
    struct mutex                driver_mutex ;

    dev_t                   chrdev_region;
    struct cdev             cdev;

    /* Have an array of hbm_chardev structures so we can index them */
    struct hbm_chardev      chardev[FPGA_CHARDEV_MINOR_SIZE];

    /* Page table */
    spinlock_t              spinlock_pagetable;
    struct page *           pExt_ram_page;
#ifdef ZBUF_CPUSHARED
    struct vm_area_struct * vmaFpga;
    struct vm_area_struct * vmaCpuShared;
#endif /* ZBUF_CPUSHARED */

    unsigned int            traceFlags;

    /* FPGA registers */
    volatile FPGA_MSGQ_REGISTER_MAP *   pFPGAMsgQ;
    volatile FPGA_SYSTEM_MAP *          pSystem;
    volatile FPGA_TIMEBASE_MAP *        pTimebase;
    volatile FPGA_DEVELOPMENT_DEBUG_MAP * pDebug;
    volatile FPGA_MASTER_SLAVE_MAP *    pMasterSlave;

#if defined(CONFIG_I2C) || defined(CONFIG_I2C_MODULE)
    int     i2c_clock_khz;//      = 125000,       /* input clock of 125MHz */
    void (*i2c_setreg)(void * fpga, unsigned int reg, unsigned int data);
    unsigned int  (*i2c_getreg)(void * fpga, unsigned int reg);
#endif
};

#endif /* __HBM_FPGA_CORE_H__ */
