#ifndef __HBM_FPGA_DRIVER_H__
#define __HBM_FPGA_DRIVER_H__

/*
 * Copyright (C) 2011 HBM Netherlands B.V.
 * Schutweg 15a
 * 5145NP Waalwijk
 * The Netherlands
 * http://www.hbm.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <linux/ioctl.h>

#define HBM_FPGA_MAGIC                          'r'
#define HBM_FPGA_IOCTL_READ_PHYSICAL_ADDRESS    _IOR(HBM_FPGA_MAGIC, 1, int)
#define HBM_FPGA_IOCTL_SET_TRACE_FLAGS          _IOW(HBM_FPGA_MAGIC, 2, int)
#define HBM_FPGA_IOCTL_MAKE_COMPOUND_PAGE       _IOW(HBM_FPGA_MAGIC, 3, compound_page_params)
#define HBM_FPGA_IOCTL_TEST_GET_PAGE            _IOW(HBM_FPGA_MAGIC, 4, compound_page_params)
#define HBM_FPGA_IOCTL_TEST_PUT_PAGE            _IOW(HBM_FPGA_MAGIC, 5, compound_page_params)
#define HBM_FPGA_IOCTL_CLEANUP_COMPOUND_PAGE    _IOW(HBM_FPGA_MAGIC, 6, compound_page_params)
#define HBM_FPGA_IOCTL_UNLOCK_COMPOUND_PAGE     _IOW(HBM_FPGA_MAGIC, 7, compound_page_params)

enum {
    FPGA_TRACE_NONE = 0,
    FPGA_TRACE_IRQ = (1 << 0),
    FPGA_TRACE_SIZE
};

typedef struct
{
    unsigned long address;
    unsigned long size;
} compound_page_params;

#endif /* __HBM_FPGA_DRIVER_H__ */
