/*
 *  Ralink RT305 SoC register definitions
 *
 *  Copyright (C) 2009 Gabor Juhos <juhosg@openwrt.org>
 *
 *  This program is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License version 2 as published
 *  by the Free Software Foundation.
 */

#ifndef _RT305X_REGS_H_
#define _RT305X_REGS_H_

#include <linux/bitops.h>

#define RT305X_SDRAM_BASE	0x00000000
#define RT305X_SYSC_BASE	0x10000000
#define RT305X_TIMER_BASE	0x10000100
#define RT305X_INTC_BASE	0x10000200
#define RT305X_MEMC_BASE	0x10000300
#define RT305X_PCM_BASE		0x10000400
#define RT305X_UART0_BASE	0x10000500
#define RT305X_PIO_BASE		0x10000600
#define RT305X_GDMA_BASE	0x10000700
#define RT305X_NANDC_BASE	0x10000800
#define RT305X_I2C_BASE		0x10000900
#define RT305X_I2S_BASE		0x10000a00
#define RT305X_SPI_BASE		0x10000b00
#define RT305X_UART1_BASE	0x10000c00
#define RT305X_FE_BASE		0x10100000
#define RT305X_SWITCH_BASE	0x10110000
#define RT305X_WMAC_BASE	0x10180000
#define RT305X_OTG_BASE		0x101c0000
#define RT305X_ROM_BASE		0x00400000
#define RT305X_FLASH1_BASE	0x1b000000
#define RT305X_FLASH0_BASE	0x1f000000

#define RT305X_SYSC_SIZE	0x100
#define RT305X_TIMER_SIZE	0x100
#define RT305X_INTC_SIZE	0x100
#define RT305X_MEMC_SIZE	0x100
#define RT305X_UART0_SIZE	0x100
#define RT305X_PIO_SIZE		0x100
#define RT305X_UART1_SIZE	0x100
#define RT305X_SPI_SIZE		0x100
#define RT305X_FLASH1_SIZE	(16 * 1024 * 1024)
#define RT305X_FLASH0_SIZE	(8 * 1024 * 1024)

#define RT3352_EHCI_BASE	0x101c0000
#define RT3352_EHCI_SIZE	0x1000
#define RT3352_OHCI_BASE	0x101c1000
#define RT3352_OHCI_SIZE	0x1000

/* SYSC registers */
#define SYSC_REG_CHIP_NAME0	0x000	/* Chip Name 0 */
#define SYSC_REG_CHIP_NAME1	0x004	/* Chip Name 1 */
#define SYSC_REG_CHIP_ID	0x00c	/* Chip Identification */
#define SYSC_REG_SYSTEM_CONFIG	0x010	/* System Configuration */
#define SYSC_REG_RESET_CTRL	0x034	/* Reset Control*/
#define SYSC_REG_RESET_STATUS	0x038	/* Reset Status*/
#define SYSC_REG_GPIO_MODE	0x060	/* GPIO Purpose Select */
#define SYSC_REG_IA_ADDRESS	0x310	/* Illegal Access Address */
#define SYSC_REG_IA_TYPE	0x314	/* Illegal Access Type */

#define RT3352_SYSC_REG_SYSCFG1		0x014
#define RT3352_SYSC_REG_CLKCFG1		0x030
#define RT3352_SYSC_REG_RSTCTRL		0x034
#define RT3352_SYSC_REG_USB_PS		0x05c

#define RT3052_CHIP_NAME0	0x30335452
#define RT3052_CHIP_NAME1	0x20203235

#define RT3350_CHIP_NAME0	0x33335452
#define RT3350_CHIP_NAME1	0x20203035

#define RT3352_CHIP_NAME0	0x33335452
#define RT3352_CHIP_NAME1	0x20203235

#define RT5350_CHIP_NAME0	0x33355452
#define RT5350_CHIP_NAME1	0x20203035

#define CHIP_ID_ID_MASK		0xff
#define CHIP_ID_ID_SHIFT	8
#define CHIP_ID_REV_MASK	0xff

#define RT305X_SYSCFG_CPUCLK_SHIFT	18
#define RT305X_SYSCFG_CPUCLK_MASK	0x1
#define RT305X_SYSCFG_CPUCLK_LOW	0x0
#define RT305X_SYSCFG_CPUCLK_HIGH	0x1
#define RT305X_SYSCFG_SRAM_CS0_MODE_SHIFT	2
#define RT305X_SYSCFG_SRAM_CS0_MODE_MASK	0x3
#define RT305X_SYSCFG_SRAM_CS0_MODE_NORMAL	0
#define RT305X_SYSCFG_SRAM_CS0_MODE_WDT		1
#define RT305X_SYSCFG_SRAM_CS0_MODE_BTCOEX	2

#define RT3352_SYSCFG0_CPUCLK_SHIFT	8
#define RT3352_SYSCFG0_CPUCLK_MASK	0x1
#define RT3352_SYSCFG0_CPUCLK_LOW	0x0
#define RT3352_SYSCFG0_CPUCLK_HIGH	0x1

#define RT5350_SYSCFG0_CPUCLK_SHIFT	8
#define RT5350_SYSCFG0_CPUCLK_MASK	0x3
#define RT5350_SYSCFG0_CPUCLK_360	0x0
#define RT5350_SYSCFG0_CPUCLK_320	0x2
#define RT5350_SYSCFG0_CPUCLK_300	0x3
#define RT5350_SYSCFG0_DRAM_SIZE_SHIFT	12
#define RT5350_SYSCFG0_DRAM_SIZE_MASK	7
#define RT5350_SYSCFG0_DRAM_SIZE_2M	0
#define RT5350_SYSCFG0_DRAM_SIZE_8M	1
#define RT5350_SYSCFG0_DRAM_SIZE_16M	2
#define RT5350_SYSCFG0_DRAM_SIZE_32M	3
#define RT5350_SYSCFG0_DRAM_SIZE_64M	4

#define RT3352_SYSCFG1_USB0_HOST_MODE	BIT(10)

#define RT3352_CLKCFG1_UPHY0_CLK_EN	BIT(18)
#define RT3352_CLKCFG1_UPHY1_CLK_EN	BIT(20)

#define RT305X_GPIO_MODE_I2C		BIT(0)
#define RT305X_GPIO_MODE_SPI		BIT(1)
#define RT305X_GPIO_MODE_UART0_SHIFT	2
#define RT305X_GPIO_MODE_UART0_MASK	0x7
#define RT305X_GPIO_MODE_UART0(x)	((x) << RT305X_GPIO_MODE_UART0_SHIFT)
#define RT305X_GPIO_MODE_UARTF		0x0
#define RT305X_GPIO_MODE_PCM_UARTF	0x1
#define RT305X_GPIO_MODE_PCM_I2S	0x2
#define RT305X_GPIO_MODE_I2S_UARTF	0x3
#define RT305X_GPIO_MODE_PCM_GPIO	0x4
#define RT305X_GPIO_MODE_GPIO_UARTF	0x5
#define RT305X_GPIO_MODE_GPIO_I2S	0x6
#define RT305X_GPIO_MODE_GPIO		0x7
#define RT305X_GPIO_MODE_UART1		BIT(5)
#define RT305X_GPIO_MODE_JTAG		BIT(6)
#define RT305X_GPIO_MODE_MDIO		BIT(7)
#define RT305X_GPIO_MODE_SDRAM		BIT(8)
#define RT305X_GPIO_MODE_RGMII		BIT(9)

#define RT305X_RESET_SYSTEM	BIT(0)
#define RT305X_RESET_TIMER	BIT(8)
#define RT305X_RESET_INTC	BIT(9)
#define RT305X_RESET_MEMC	BIT(10)
#define RT305X_RESET_PCM	BIT(11)
#define RT305X_RESET_UART0	BIT(12)
#define RT305X_RESET_PIO	BIT(13)
#define RT305X_RESET_DMA	BIT(14)
#define RT305X_RESET_I2C	BIT(16)
#define RT305X_RESET_I2S	BIT(17)
#define RT305X_RESET_SPI	BIT(18)
#define RT305X_RESET_UART1	BIT(19)
#define RT305X_RESET_WNIC	BIT(20)
#define RT305X_RESET_FE		BIT(21)
#define RT305X_RESET_OTG	BIT(22)
#define RT305X_RESET_ESW	BIT(23)

#define RT3352_RSTCTRL_SYS	BIT(0)
#define RT3352_RSTCTRL_TIMER	BIT(8)
#define RT3352_RSTCTRL_INTC	BIT(9)
#define RT3352_RSTCTRL_MEMC	BIT(10)
#define RT3352_RSTCTRL_PCM	BIT(11)
#define RT3352_RSTCTRL_UART0	BIT(12)
#define RT3352_RSTCTRL_PIO	BIT(13)
#define RT3352_RSTCTRL_DMA	BIT(14)
#define RT3352_RSTCTRL_I2C	BIT(16)
#define RT3352_RSTCTRL_I2S	BIT(17)
#define RT3352_RSTCTRL_SPI	BIT(18)
#define RT3352_RSTCTRL_UART1	BIT(19)
#define RT3352_RSTCTRL_WNIC	BIT(20)
#define RT3352_RSTCTRL_FE	BIT(21)
#define RT3352_RSTCTRL_UHST	BIT(22)
#define RT3352_RSTCTRL_ESW	BIT(23)
#define RT3352_RSTCTRL_EPHY	BIT(24)
#define RT3352_RSTCTRL_UDEV	BIT(25)

#define RT305X_INTC_INT_SYSCTL	BIT(0)
#define RT305X_INTC_INT_TIMER0	BIT(1)
#define RT305X_INTC_INT_TIMER1	BIT(2)
#define RT305X_INTC_INT_IA	BIT(3)
#define RT305X_INTC_INT_PCM	BIT(4)
#define RT305X_INTC_INT_UART0	BIT(5)
#define RT305X_INTC_INT_PIO	BIT(6)
#define RT305X_INTC_INT_DMA	BIT(7)
#define RT305X_INTC_INT_NAND	BIT(8)
#define RT305X_INTC_INT_PERFC	BIT(9)
#define RT305X_INTC_INT_I2S	BIT(10)
#define RT305X_INTC_INT_UART1	BIT(12)
#define RT305X_INTC_INT_ESW	BIT(17)
#define RT305X_INTC_INT_OTG	BIT(18)
#define RT305X_INTC_INT_GLOBAL	BIT(31)

/* MEMC registers */
#define MEMC_REG_SDRAM_CFG0	0x00
#define MEMC_REG_SDRAM_CFG1	0x04
#define MEMC_REG_FLASH_CFG0	0x08
#define MEMC_REG_FLASH_CFG1	0x0c
#define MEMC_REG_IA_ADDR	0x10
#define MEMC_REG_IA_TYPE	0x14

#define FLASH_CFG_WIDTH_SHIFT	26
#define FLASH_CFG_WIDTH_MASK	0x3
#define FLASH_CFG_WIDTH_8BIT	0x0
#define FLASH_CFG_WIDTH_16BIT	0x1
#define FLASH_CFG_WIDTH_32BIT	0x2

/* UART registers */
#define UART_REG_RX	0
#define UART_REG_TX	1
#define UART_REG_IER	2
#define UART_REG_IIR	3
#define UART_REG_FCR	4
#define UART_REG_LCR	5
#define UART_REG_MCR	6
#define UART_REG_LSR	7

#endif /* _RT305X_REGS_H_ */
