#ifndef _GTA02_H
#define _GTA02_H

#include <mach/regs-gpio.h>
#include <mach/gpio.h>
#include <mach/irqs.h>

/* Different hardware revisions, passed in ATAG_REVISION by u-boot */
#define GTA02v1_SYSTEM_REV	0x00000310
#define GTA02v2_SYSTEM_REV	0x00000320
#define GTA02v3_SYSTEM_REV	0x00000330
#define GTA02v4_SYSTEM_REV	0x00000340
#define GTA02v5_SYSTEM_REV	0x00000350
#define GTA02v6_SYSTEM_REV	0x00000360

#define GTA02_GPIO_n3DL_GSM	S3C2410_GPA13	/* v1 + v2 + v3 only */

#define GTA02_GPIO_PWR_LED1	S3C2410_GPB0
#define GTA02_GPIO_PWR_LED2	S3C2410_GPB1
#define GTA02_GPIO_AUX_LED	S3C2410_GPB2
#define GTA02_GPIO_VIBRATOR_ON	S3C2410_GPB3
#define GTA02_GPIO_MODEM_RST	S3C2410_GPB5
#define GTA02_GPIO_BT_EN	S3C2410_GPB6
#define GTA02_GPIO_MODEM_ON	S3C2410_GPB7
#define GTA02_GPIO_EXTINT8	S3C2410_GPB8
#define GTA02_GPIO_USB_PULLUP	S3C2410_GPB9

#define GTA02_GPIO_PIO5		S3C2410_GPC5	/* v3 + v4 only */
#define GTA02v3_GPIO_nG1_CS	S3C2410_GPD12	/* v3 + v4 only */
#define GTA02v3_GPIO_nG2_CS	S3C2410_GPD13	/* v3 + v4 only */
#define GTA02v5_GPIO_HDQ	S3C2410_GPD14   /* v5 + */

#define GTA02_GPIO_nG1_INT	S3C2410_GPF0
#define GTA02_GPIO_IO1		S3C2410_GPF1
#define GTA02_GPIO_PIO_2	S3C2410_GPF2	/* v2 + v3 + v4 only */
#define GTA02_GPIO_JACK_INSERT	S3C2410_GPF4
#define GTA02_GPIO_WLAN_GPIO1	S3C2410_GPF5	/* v2 + v3 + v4 only */
#define GTA02_GPIO_AUX_KEY	S3C2410_GPF6
#define GTA02_GPIO_HOLD_KEY	S3C2410_GPF7

#define GTA02_GPIO_3D_IRQ	S3C2410_GPG4
#define GTA02v2_GPIO_nG2_INT	S3C2410_GPG8	/* v2 + v3 + v4 only */
#define GTA02v3_GPIO_nUSB_OC	S3C2410_GPG9	/* v3 + v4 only */
#define GTA02v3_GPIO_nUSB_FLT	S3C2410_GPG10	/* v3 + v4 only */
#define GTA02v3_GPIO_nGSM_OC	S3C2410_GPG11	/* v3 + v4 only */

#define GTA02_GPIO_AMP_SHUT	S3C2440_GPJ1	/* v2 + v3 + v4 only */
#define GTA02v1_GPIO_WLAN_GPIO10	S3C2440_GPJ2
#define GTA02_GPIO_HP_IN	S3C2440_GPJ2	/* v2 + v3 + v4 only */
#define GTA02_GPIO_INT0		S3C2440_GPJ3	/* v2 + v3 + v4 only */
#define GTA02_GPIO_nGSM_EN	S3C2440_GPJ4
#define GTA02_GPIO_3D_RESET	S3C2440_GPJ5
#define GTA02_GPIO_nDL_GSM	S3C2440_GPJ6	/* v4 + v5 only */
#define GTA02_GPIO_WLAN_GPIO0	S3C2440_GPJ7
#define GTA02v1_GPIO_BAT_ID	S3C2440_GPJ8
#define GTA02_GPIO_KEEPACT	S3C2440_GPJ8
#define GTA02v1_GPIO_HP_IN	S3C2440_GPJ10
#define GTA02_CHIP_PWD		S3C2440_GPJ11	/* v2 + v3 + v4 only */
#define GTA02_GPIO_nWLAN_RESET	S3C2440_GPJ12	/* v2 + v3 + v4 only */

#define GTA02_IRQ_GSENSOR_1	IRQ_EINT0
#define GTA02_IRQ_MODEM		IRQ_EINT1
#define GTA02_IRQ_PIO_2		IRQ_EINT2	/* v2 + v3 + v4 only */
#define GTA02_IRQ_nJACK_INSERT	IRQ_EINT4
#define GTA02_IRQ_WLAN_GPIO1	IRQ_EINT5
#define GTA02_IRQ_AUX		IRQ_EINT6
#define GTA02_IRQ_nHOLD		IRQ_EINT7
#define GTA02_IRQ_PCF50633	IRQ_EINT9
#define GTA02_IRQ_3D		IRQ_EINT12
#define GTA02_IRQ_GSENSOR_2	IRQ_EINT16	/* v2 + v3 + v4 only */
#define GTA02v3_IRQ_nUSB_OC	IRQ_EINT17	/* v3 + v4 only */
#define GTA02v3_IRQ_nUSB_FLT	IRQ_EINT18	/* v3 + v4 only */
#define GTA02v3_IRQ_nGSM_OC	IRQ_EINT19	/* v3 + v4 only */

/* returns 00 000 on GTA02 A5 and earlier, A6 returns 01 001 */
#define GTA02_PCB_ID1_0		S3C2410_GPC13
#define GTA02_PCB_ID1_1		S3C2410_GPC15
#define GTA02_PCB_ID1_2		S3C2410_GPD0
#define GTA02_PCB_ID2_0		S3C2410_GPD3
#define GTA02_PCB_ID2_1		S3C2410_GPD4

#define GTA02_GPIO_GLAMO_BASE S3C_GPIO_END
#define GTA02_GPIO_GLAMO(x) (GTA02_GPIO_GLAMO_BASE + x)

int gta02_get_pcb_revision(void);

extern struct pcf50633 *gta02_pcf;

#endif /* _GTA02_H */
